/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.ui.i18n;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FileUtils;
import technology.rocketjump.undermount.assets.TextureAtlasRepository;
import technology.rocketjump.undermount.ui.i18n.I18nKey;
import technology.rocketjump.undermount.ui.i18n.I18nLanguageDictionary;
import technology.rocketjump.undermount.ui.i18n.I18nWord;
import technology.rocketjump.undermount.ui.i18n.LanguageType;

@Singleton
public class I18nRepo {
    private final MessageDispatcher messageDispatcher;
    private final Map<String, I18nLanguageDictionary> dictionaries;
    private final List<LanguageType> languages;
    private I18nLanguageDictionary currentLanguageDictionary;

    @Inject
    public I18nRepo(TextureAtlasRepository textureAtlasRepository, MessageDispatcher messageDispatcher) throws IOException {
        this.messageDispatcher = messageDispatcher;
        File languagesCsvFile = new File("assets/translations/collated.csv");
        File languagesJsonFile = new File("assets/translations/languages.json");
        ConcurrentHashMap<String, I18nLanguageDictionary> dictionaries = new ConcurrentHashMap<String, I18nLanguageDictionary>();
        TextureAtlas textureAtlas = textureAtlasRepository.get(TextureAtlasRepository.TextureAtlasType.GUI_TEXTURE_ATLAS);
        ObjectMapper objectMapper = new ObjectMapper();
        List expectedLanguages = (List)objectMapper.readValue(FileUtils.readFileToString(languagesJsonFile, "UTF-8"), objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, LanguageType.class));
        for (LanguageType expectedLanguage : expectedLanguages) {
            expectedLanguage.setIconSprite(textureAtlas.createSprite(expectedLanguage.getIcon()));
            dictionaries.put(expectedLanguage.getLabelEn().toUpperCase(), new I18nLanguageDictionary(expectedLanguage.getLabel(), expectedLanguage.getLabelEn(), expectedLanguage.getIcon()));
        }
        CSVParser parsedCsv = CSVParser.parse(languagesCsvFile, Charset.forName("UTF-8"), CSVFormat.newFormat('|'));
        HashMap<String, Integer> columnIndices = new HashMap<String, Integer>();
        for (CSVRecord csvRecord : parsedCsv.getRecords()) {
            if (columnIndices.isEmpty()) {
                for (int cursor = 0; cursor < csvRecord.size(); ++cursor) {
                    columnIndices.put(csvRecord.get(cursor).toUpperCase(), cursor);
                }
                continue;
            }
            String key = csvRecord.get((Integer)columnIndices.get("KEY"));
            if (key == null || key.isEmpty()) continue;
            key = key.toUpperCase();
            for (I18nLanguageDictionary dictionary : dictionaries.values()) {
                String translatedValue;
                Integer index = (Integer)columnIndices.get(dictionary.getLabelEn().toUpperCase());
                if (index == null || (translatedValue = csvRecord.get(index)) == null || translatedValue.isEmpty()) continue;
                translatedValue = translatedValue.trim();
                this.addValueTo(dictionary, key, translatedValue);
            }
        }
        this.dictionaries = dictionaries;
        this.languages = expectedLanguages;
        this.currentLanguageDictionary = this.dictionaries.get("ENGLISH");
    }

    public List<LanguageType> getAllLanguages() {
        return this.languages;
    }

    public I18nLanguageDictionary getCurrentLanguage() {
        return this.currentLanguageDictionary;
    }

    public void setCurrentLanguage(LanguageType languageType) {
        this.currentLanguageDictionary = this.dictionaries.get(languageType.getLabelEn().toUpperCase());
    }

    private void addValueTo(I18nLanguageDictionary dictionary, String keyString, String translatedValue) {
        I18nKey key = new I18nKey(keyString);
        I18nWord word = dictionary.getWord(key.key);
        word.add(key, translatedValue);
    }
}

